---
generated_at: 2026-01-22 10:50:00
metrics:
  claims_total: 12
  claims_with_evidence: 12
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：5-Internal Server Error通知

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：12 / 12、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `src/Horse.Core.RouterTree.NextCaller.pas` 行109 - FResponse.Send('Internal Application Error').Status(THTTPStatus.InternalServerError)
- E-02: `src/Horse.Core.RouterTree.NextCaller.pas` 行105 - not(E is EHorseCallbackInterrupted)
- E-03: `src/Horse.Core.RouterTree.NextCaller.pas` 行106 - not(E is EHorseException)
- E-04: `src/Horse.Core.RouterTree.NextCaller.pas` 行107 - FResponse.Status < Integer(THTTPStatus.BadRequest)
- E-05: `src/Horse.Core.RouterTree.NextCaller.pas` 行110 - raise
- E-06: `src/Horse.Core.RouterTree.NextCaller.pas` 行101 - LCallback.Items[FIndexCallback](FRequest, FResponse, Next)
- E-07: `src/Horse.Commons.pas` 行76 - InternalServerError = 500
- E-08: `src/Horse.Commons.pas` 行46 - BadRequest = 400
- E-09: `src/Horse.Exception.pas` 行21 - EHorseException = class(Exception)
- E-10: `src/Horse.Core.RouterTree.NextCaller.pas` 行102-111 - except on E: Exception do

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | HTTPステータス500が返却される | E-01, E-07 | ○ |
| C-02 | メッセージは「Internal Application Error」 | E-01 | ○ |
| C-03 | EHorseCallbackInterrupted以外の例外が条件 | E-02 | ○ |
| C-04 | EHorseException以外の例外が条件 | E-03 | ○ |
| C-05 | FResponse.Status < 400 が条件 | E-04, E-08 | ○ |
| C-06 | 例外は500エラー後も再throwされる | E-05 | ○ |
| C-07 | コールバック実行中の例外がトリガー | E-06, E-10 | ○ |
| C-08 | THTTPStatus.InternalServerErrorの値は500 | E-07 | ○ |
| C-09 | THTTPStatus.BadRequestの値は400 | E-08 | ○ |
| C-10 | EHorseExceptionはException派生クラス | E-09 | ○ |
| C-11 | 3条件すべてを満たす場合のみ送信 | E-02, E-03, E-04 | ○ |
| C-12 | FResponse.SendとStatusのメソッドチェーン | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）
- 不足情報なし
- すべての主張がソースコードから直接確認可能

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がソースコードで裏付けられている

## 6) レビュアーチェックリスト（最小）
- [ ] `Horse.Core.RouterTree.NextCaller.pas`の行109で500エラーが送信されることを確認
- [ ] 行105-107の3条件が正しいことを確認
- [ ] 行110でraiseにより例外が再throwされることを確認
